/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Colors;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;

public class GlyphLayout
implements Pool.Poolable {
    public final Array<GlyphRun> runs = new Array();
    public float width;
    public float height;
    private final Array<Color> colorStack = new Array(4);

    public GlyphLayout() {
    }

    public GlyphLayout(BitmapFont font, CharSequence str) {
        this.setText(font, str);
    }

    public GlyphLayout(BitmapFont font, CharSequence str, Color color, float targetWidth, int halign, boolean wrap) {
        this.setText(font, str, color, targetWidth, halign, wrap);
    }

    public GlyphLayout(BitmapFont font, CharSequence str, int start, int end, Color color, float targetWidth, int halign, boolean wrap, String truncate2) {
        this.setText(font, str, start, end, color, targetWidth, halign, wrap, truncate2);
    }

    public void setText(BitmapFont font, CharSequence str) {
        this.setText(font, str, 0, str.length(), font.getColor(), 0.0f, 8, false, null);
    }

    public void setText(BitmapFont font, CharSequence str, Color color, float targetWidth, int halign, boolean wrap) {
        this.setText(font, str, 0, str.length(), color, targetWidth, halign, wrap, null);
    }

    public void setText(BitmapFont font, CharSequence str, int start, int end, Color color, float targetWidth, int halign, boolean wrap, String truncate2) {
        int i;
        if (truncate2 != null) {
            wrap = true;
        } else if (targetWidth <= font.data.spaceWidth) {
            wrap = false;
        }
        BitmapFont.BitmapFontData fontData = font.data;
        boolean markupEnabled = fontData.markupEnabled;
        Pool<GlyphRun> glyphRunPool = Pools.get(GlyphRun.class);
        Array<GlyphRun> runs = this.runs;
        glyphRunPool.freeAll(runs);
        runs.clear();
        float x = 0.0f;
        float y = 0.0f;
        float width = 0.0f;
        int lines2 = 0;
        Array<Color> colorStack = this.colorStack;
        Color nextColor = color;
        colorStack.add(color);
        Pool<Color> colorPool = Pools.get(Color.class);
        int runStart = start;
        block4: while (true) {
            int runEnd = -1;
            boolean newline = false;
            boolean colorRun = false;
            if (start == end) {
                if (runStart == end) break;
                runEnd = end;
            } else {
                switch (str.charAt(start++)) {
                    case '\n': {
                        runEnd = start - 1;
                        newline = true;
                        break;
                    }
                    case '[': {
                        int length;
                        if (!markupEnabled || (length = this.parseColorMarkup(str, start, end, colorPool)) < 0) break;
                        runEnd = start - 1;
                        start += length + 1;
                        nextColor = colorStack.peek();
                        colorRun = true;
                    }
                }
            }
            if (runEnd == -1) continue;
            if (runEnd != runStart) {
                GlyphRun run2 = glyphRunPool.obtain();
                run2.color.set(color);
                run2.x = x;
                run2.y = y;
                fontData.getGlyphs(run2, str, runStart, runEnd, colorRun);
                if (run2.glyphs.size == 0) {
                    glyphRunPool.free(run2);
                } else {
                    runs.add(run2);
                    float[] xAdvances = run2.xAdvances.items;
                    int n = run2.xAdvances.size;
                    for (i = 0; i < n; ++i) {
                        float xAdvance = xAdvances[i];
                        x += xAdvance;
                        if (wrap && x > targetWidth && i > 1 && x - xAdvance + (float)(run2.glyphs.get((int)(i - 1)).xoffset + run2.glyphs.get((int)(i - 1)).width) * fontData.scaleX - 1.0E-4f > targetWidth) {
                            if (truncate2 != null) {
                                this.truncate(fontData, run2, targetWidth, truncate2, i, glyphRunPool);
                                x = run2.x + run2.width;
                                break block4;
                            }
                            int wrapIndex = fontData.getWrapIndex(run2.glyphs, i);
                            if (run2.x == 0.0f && wrapIndex == 0 || wrapIndex >= run2.glyphs.size) {
                                wrapIndex = i - 1;
                            }
                            GlyphRun next2 = this.wrap(fontData, run2, glyphRunPool, wrapIndex, i);
                            runs.add(next2);
                            width = Math.max(width, run2.x + run2.width);
                            x = 0.0f;
                            ++lines2;
                            next2.x = 0.0f;
                            next2.y = y += fontData.down;
                            i = -1;
                            n = next2.xAdvances.size;
                            xAdvances = next2.xAdvances.items;
                            run2 = next2;
                            continue;
                        }
                        run2.width += xAdvance;
                    }
                }
            }
            if (newline) {
                width = Math.max(width, x);
                x = 0.0f;
                y += fontData.down;
                ++lines2;
            }
            runStart = start;
            color = nextColor;
        }
        width = Math.max(width, x);
        int n = colorStack.size;
        for (int i2 = 1; i2 < n; ++i2) {
            colorPool.free(colorStack.get(i2));
        }
        colorStack.clear();
        if ((halign & 8) == 0) {
            boolean center2 = (halign & 1) != 0;
            float lineWidth = 0.0f;
            float lineY = -2.1474836E9f;
            int lineStart = 0;
            int n2 = runs.size;
            for (i = 0; i < n2; ++i) {
                GlyphRun run3 = runs.get(i);
                if (run3.y != lineY) {
                    lineY = run3.y;
                    float shift = targetWidth - lineWidth;
                    if (center2) {
                        shift /= 2.0f;
                    }
                    while (lineStart < i) {
                        runs.get((int)lineStart++).x += shift;
                    }
                    lineWidth = 0.0f;
                }
                lineWidth += run3.width;
            }
            float shift = targetWidth - lineWidth;
            if (center2) {
                shift /= 2.0f;
            }
            while (lineStart < n2) {
                runs.get((int)lineStart++).x += shift;
            }
        }
        this.width = width;
        this.height = fontData.capHeight + (float)lines2 * fontData.lineHeight;
    }

    private void truncate(BitmapFont.BitmapFontData fontData, GlyphRun run2, float targetWidth, String truncate2, int widthIndex, Pool<GlyphRun> glyphRunPool) {
        int count2;
        GlyphRun truncateRun = glyphRunPool.obtain();
        fontData.getGlyphs(truncateRun, truncate2, 0, truncate2.length(), true);
        float truncateWidth = 0.0f;
        int n = truncateRun.xAdvances.size;
        for (int i = 1; i < n; ++i) {
            truncateWidth += truncateRun.xAdvances.get(i);
        }
        targetWidth -= truncateWidth;
        float width = run2.x;
        for (count2 = 0; count2 < run2.xAdvances.size; ++count2) {
            float xAdvance = run2.xAdvances.get(count2);
            if (!((width += xAdvance) > targetWidth)) continue;
            run2.width = width - run2.x - xAdvance;
            break;
        }
        if (count2 > 1) {
            run2.glyphs.truncate(count2 - 1);
            run2.xAdvances.truncate(count2);
            this.adjustLastGlyph(fontData, run2);
            if (truncateRun.xAdvances.size > 0) {
                run2.xAdvances.addAll(truncateRun.xAdvances, 1, truncateRun.xAdvances.size - 1);
            }
        } else {
            run2.glyphs.clear();
            run2.xAdvances.clear();
            run2.xAdvances.addAll(truncateRun.xAdvances);
            if (truncateRun.xAdvances.size > 0) {
                run2.width += truncateRun.xAdvances.get(0);
            }
        }
        run2.glyphs.addAll(truncateRun.glyphs);
        run2.width += truncateWidth;
        glyphRunPool.free(truncateRun);
    }

    private GlyphRun wrap(BitmapFont.BitmapFontData fontData, GlyphRun first, Pool<GlyphRun> glyphRunPool, int wrapIndex, int widthIndex) {
        GlyphRun second = glyphRunPool.obtain();
        second.color.set(first.color);
        int glyphCount = first.glyphs.size;
        if (wrapIndex < glyphCount) {
            second.glyphs.addAll(first.glyphs, wrapIndex, glyphCount - wrapIndex);
            second.xAdvances.add((float)(-second.glyphs.first().xoffset) * fontData.scaleX - fontData.padLeft);
            second.xAdvances.addAll(first.xAdvances, wrapIndex + 1, first.xAdvances.size - (wrapIndex + 1));
        }
        while (widthIndex < wrapIndex) {
            first.width += first.xAdvances.get(widthIndex++);
        }
        while (widthIndex > wrapIndex + 1) {
            first.width -= first.xAdvances.get(--widthIndex);
        }
        if (wrapIndex == 0) {
            glyphRunPool.free(first);
            this.runs.pop();
        } else {
            first.glyphs.truncate(wrapIndex);
            first.xAdvances.truncate(wrapIndex + 1);
            this.adjustLastGlyph(fontData, first);
        }
        return second;
    }

    private void adjustLastGlyph(BitmapFont.BitmapFontData fontData, GlyphRun run2) {
        BitmapFont.Glyph last2 = run2.glyphs.peek();
        if (fontData.isWhitespace((char)last2.id)) {
            return;
        }
        float width = (float)(last2.xoffset + last2.width) * fontData.scaleX - fontData.padRight;
        run2.width += width - run2.xAdvances.peek();
        run2.xAdvances.set(run2.xAdvances.size - 1, width);
    }

    private int parseColorMarkup(CharSequence str, int start, int end, Pool<Color> colorPool) {
        if (start == end) {
            return -1;
        }
        switch (str.charAt(start)) {
            case '#': {
                int colorInt = 0;
                for (int i = start + 1; i < end; ++i) {
                    char ch = str.charAt(i);
                    if (ch == ']') {
                        if (i < start + 2 || i > start + 9) break;
                        if (i - start <= 7) {
                            int nn = 9 - (i - start);
                            for (int ii = 0; ii < nn; ++ii) {
                                colorInt <<= 4;
                            }
                            colorInt |= 0xFF;
                        }
                        Color color = colorPool.obtain();
                        this.colorStack.add(color);
                        Color.rgba8888ToColor(color, colorInt);
                        return i - start;
                    }
                    if (ch >= '0' && ch <= '9') {
                        colorInt = colorInt * 16 + (ch - 48);
                        continue;
                    }
                    if (ch >= 'a' && ch <= 'f') {
                        colorInt = colorInt * 16 + (ch - 87);
                        continue;
                    }
                    if (ch < 'A' || ch > 'F') break;
                    colorInt = colorInt * 16 + (ch - 55);
                }
                return -1;
            }
            case '[': {
                return -1;
            }
            case ']': {
                if (this.colorStack.size > 1) {
                    colorPool.free(this.colorStack.pop());
                }
                return 0;
            }
        }
        int colorStart = start;
        for (int i = start + 1; i < end; ++i) {
            char ch = str.charAt(i);
            if (ch != ']') continue;
            Color namedColor = Colors.get(str.subSequence(colorStart, i).toString());
            if (namedColor == null) {
                return -1;
            }
            Color color = colorPool.obtain();
            this.colorStack.add(color);
            color.set(namedColor);
            return i - start;
        }
        return -1;
    }

    @Override
    public void reset() {
        Pools.get(GlyphRun.class).freeAll(this.runs);
        this.runs.clear();
        this.width = 0.0f;
        this.height = 0.0f;
    }

    public String toString() {
        if (this.runs.size == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(this.width);
        buffer.append('x');
        buffer.append(this.height);
        buffer.append('\n');
        int n = this.runs.size;
        for (int i = 0; i < n; ++i) {
            buffer.append(this.runs.get(i).toString());
            buffer.append('\n');
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    public static class GlyphRun
    implements Pool.Poolable {
        public final Array<BitmapFont.Glyph> glyphs = new Array();
        public final FloatArray xAdvances = new FloatArray();
        public float x;
        public float y;
        public float width;
        public final Color color = new Color();

        @Override
        public void reset() {
            this.glyphs.clear();
            this.xAdvances.clear();
            this.width = 0.0f;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.glyphs.size);
            Array<BitmapFont.Glyph> glyphs = this.glyphs;
            int n = glyphs.size;
            for (int i = 0; i < n; ++i) {
                BitmapFont.Glyph g = glyphs.get(i);
                buffer.append((char)g.id);
            }
            buffer.append(", #");
            buffer.append(this.color);
            buffer.append(", ");
            buffer.append(this.x);
            buffer.append(", ");
            buffer.append(this.y);
            buffer.append(", ");
            buffer.append(this.width);
            return buffer.toString();
        }
    }
}

